/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.design.property.tables;

import filenet.vw.api.VWFieldDefinition;
import filenet.vw.toolkit.design.property.VWAuthPropertyData;
import filenet.vw.toolkit.utils.table.VWLabelListCellRenderer;
import filenet.vw.toolkit.utils.table.VWQubbleSort;
import java.awt.Component;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.EventListenerList;
import javax.swing.plaf.basic.BasicComboBoxEditor;
import javax.swing.table.TableCellEditor;

public class VWFieldNameCellEditor
implements TableCellEditor,
KeyListener {
    protected EventListenerList m_listenerList = null;
    protected transient ChangeEvent m_changeEvent = null;
    protected VWAuthPropertyData m_authPropertyData = null;
    protected JComboBox m_combo = null;
    protected BasicComboBoxEditor m_editor = null;
    protected int m_clickCountToStart = 0;
    protected String m_currentValue = null;

    public VWFieldNameCellEditor(VWAuthPropertyData authPropertyData) {
        this.m_authPropertyData = authPropertyData;
        this.m_listenerList = new EventListenerList();
        this.m_combo = new JComboBox();
        this.m_combo.setEditable(true);
        this.m_combo.setRenderer(new VWLabelListCellRenderer());
        this.m_editor = new BasicComboBoxEditor();
        this.m_editor.getEditorComponent().addKeyListener(this);
        this.m_combo.setEditor(this.m_editor);
        this.setClickCountToStart(1);
    }

    public void updateCurrentValue() {
        Object selItem = this.m_editor.getItem();
        if (selItem != null && selItem instanceof String) {
            this.m_currentValue = (String)selItem;
        }
    }

    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        if (this.m_authPropertyData != null && this.m_combo != null) {
            this.m_combo.removeAllItems();
            Object[] fieldDefs = this.m_authPropertyData.getFields();
            if (fieldDefs != null && fieldDefs.length > 0) {
                try {
                    VWQubbleSort.sort(fieldDefs);
                }
                catch (Exception ex) {
                    // empty catch block
                }
                for (int nIndex = 0; nIndex < fieldDefs.length; ++nIndex) {
                    if (fieldDefs[nIndex] == null) continue;
                    this.m_combo.addItem(((VWFieldDefinition)fieldDefs[nIndex]).getName());
                }
            }
            this.m_combo.setSelectedIndex(-1);
        }
        if (value != null && value instanceof String) {
            this.setValue(value);
        }
        if (this.m_combo != null) {
            this.m_combo.setComponentOrientation(table.getComponentOrientation());
            if (this.m_editor.getEditorComponent() instanceof JTextField) {
                ((JTextField)this.m_editor.getEditorComponent()).setComponentOrientation(table.getComponentOrientation());
            }
        }
        return this.m_combo;
    }

    public void addCellEditorListener(CellEditorListener listener) {
        this.m_listenerList.add(CellEditorListener.class, listener);
    }

    public boolean isCellEditable(EventObject anEvent) {
        return !(anEvent instanceof MouseEvent) || ((MouseEvent)anEvent).getClickCount() >= this.m_clickCountToStart;
    }

    public void removeCellEditorListener(CellEditorListener listener) {
        this.m_listenerList.remove(CellEditorListener.class, listener);
    }

    public boolean shouldSelectCell(EventObject anEvent) {
        if (this.isCellEditable(anEvent) && (anEvent == null || ((MouseEvent)anEvent).getClickCount() >= this.m_clickCountToStart)) {
            return this.startCellEditing(anEvent);
        }
        return true;
    }

    public boolean stopCellEditing() {
        this.updateCurrentValue();
        this.fireEditingStopped();
        return true;
    }

    public int getClickCountToStart() {
        return this.m_clickCountToStart;
    }

    public Component getComponent() {
        return this.m_combo;
    }

    public void setClickCountToStart(int count) {
        this.m_clickCountToStart = count;
    }

    public void cancelCellEditing() {
        this.fireEditingCanceled();
    }

    public Object getCellEditorValue() {
        return this.m_currentValue;
    }

    public void setValue(Object value) {
        if (value != null && value instanceof String) {
            this.m_currentValue = (String)value;
            this.m_editor.setItem(value);
        }
    }

    public boolean startCellEditing(EventObject anEvent) {
        return true;
    }

    public void keyPressed(KeyEvent event) {
    }

    public void keyReleased(KeyEvent event) {
    }

    public void keyTyped(KeyEvent event) {
        if (event.getKeyChar() == '\n') {
            this.stopCellEditing();
        }
    }

    protected void fireEditingStopped() {
        Object[] listeners = this.m_listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != CellEditorListener.class) continue;
            if (this.m_changeEvent == null) {
                this.m_changeEvent = new ChangeEvent(this);
            }
            ((CellEditorListener)listeners[i + 1]).editingStopped(this.m_changeEvent);
        }
    }

    protected void fireEditingCanceled() {
        Object[] listeners = this.m_listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != CellEditorListener.class) continue;
            if (this.m_changeEvent == null) {
                this.m_changeEvent = new ChangeEvent(this);
            }
            ((CellEditorListener)listeners[i + 1]).editingCanceled(this.m_changeEvent);
        }
    }
}

